
 include "MC56F8006.inc"
 include "MC56F8006_init.inc"
 
 
  	set	SEE_SYSCLK	1
 	set CLK_OPTION	$2006 ; $2000 ; 
 	set PLL_DIVIDER $2000 ; $2200 
 	set USE_EXT_CLK 0


	section rtlib
	
	
	org p:
	
	GLOBAL Ftrim_rosc
	
Ftrim_rosc:

    ;; Set TRIM bits using Flash Config Data
    move.l   #FM_OPT0,R0            ; set R0 as pointer to factory-flashed trim value
    move.l   #PMC_CR2,R1            ; set R1 as pointer to PMC_CR2
    move.w   X:(R0),A               ; set A as factory-flashed trim value
    move.w   A1,X:(R1)              ; set PMC_CR2
  
  ; get trim value and set trim reg
	
	move.l   #OCCS_OCTRL,R1    ; set R1 and R0 to OCCS_OCTRL
	move.l   #OCCS_OCTRL,R0
	move.w   X:(R0),A     ; set A to current OSCT value
	move.w   #$FC00,B     ; set B to mask
	and.w    A,B          ; mask A
	move.l   #FM_OPT1,R0   ; set R0 to factory-flashed trim value
	move.w   X:(R0),A     ; set A
	or.w     B,A          ; or A and B to get full OSCTL value
	move.w   A1,X:(R1)    ; set OSCTL
	
	;-- Output the system clock now ---
	IF (SEE_SYSCLK)
		move.w #$0800,X:(SIM_GPSB0)	; GPIOB4 as CLKO_0
		bfset  #$0010,X:(GPIOB_PER)
		move.w #CLK_OPTION,X:(SIM_CLKOUT)
	ENDIF
	      
	;-- Switch to external clock ---
	IF (USE_EXT_CLK) 
	   ; change GPIO periperal select to CLKIN
	   bfset	#$0003,X:>SIM_GPSB1	   
	   bfset	#$0040,X:>GPIOB_PER		; Enabling GPIOB6 (CLKIN) pin by writing into GPIOB_PER register
	   bfset	#$0400,X:>OCCS_OCTRL		; Set EXT_SEL to 1 to select CLKIN
	   bfset	#$0004,X:>OCCS_CTRL		; Changing PRECS to '1' to select the external clk source (direct) bypassing the COSC and ROSC
	   DUP	10
	       NOP							; wait x NOPs
	   ENDM
	   bfset	#$8000,X:>OCCS_OCTRL	; power down ROSC
	ENDIF
	rts
    
    ENDSEC


